<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/functions.php';

$users = read_json('users.json');

// CHANGE THESE TO WHATEVER YOU WANT
$email    = 'luke@londonsenergyradio.co.uk';
$password = 'Online2020';
$name     = 'Londons Energy';

// Check if admin already exists
foreach ($users as $u) {
    if (strtolower($u['email']) === strtolower($email)) {
        echo "Admin user with this email already exists.";
        exit;
    }
}

$newId = $users ? (max(array_column($users, 'id')) + 1) : 1;

$users[] = [
    "id"            => $newId,
    "role"          => "admin",
    "name"          => $name,
    "email"         => $email,
    "password_hash" => password_hash($password, PASSWORD_DEFAULT),
    "status"        => "active"
];

write_json('users.json', $users);

echo "Admin created. You can now login with:<br>";
echo "Email: " . htmlspecialchars($email) . "<br>";
echo "Password: " . htmlspecialchars($password) . "<br>";
