<?php

function read_json($filename) {
    $path = DATA_PATH . $filename;
    if (!file_exists($path)) {
        return [];
    }
    $json = file_get_contents($path);
    $data = json_decode($json, true);
    return is_array($data) ? $data : [];
}

function write_json($filename, $data) {
    $path = DATA_PATH . $filename;
    $json = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $fp = fopen($path, 'c+');
    if (!$fp) return false;

    flock($fp, LOCK_EX);
    ftruncate($fp, 0);
    fwrite($fp, $json);
    fflush($fp);
    flock($fp, LOCK_UN);
    fclose($fp);

    return true;
}

function slugify($text) {
    $text = strtolower(trim($text));
    $text = preg_replace('~[^a-z0-9]+~', '-', $text);
    return trim($text, '-');
}

function find_artist_by_slug($slug) {
    $artists = read_json('artists.json');
    foreach ($artists as $artist) {
        if ($artist['slug'] === $slug) return $artist;
    }
    return null;
}

function update_artist_by_slug($slug, $newData) {
    $artists = read_json('artists.json');
    foreach ($artists as &$artist) {
        if ($artist['slug'] === $slug) {
            $artist = array_merge($artist, $newData);
            return write_json('artists.json', $artists);
        }
    }
    return false;
}

function find_user_by_email($email) {
    $users = read_json('users.json');
    foreach ($users as $user) {
        if (strtolower($user['email']) === strtolower($email)) return $user;
    }
    return null;
}

function find_user_by_id($id) {
    $users = read_json('users.json');
    foreach ($users as $user) {
        if ($user['id'] == $id) return $user;
    }
    return null;
}

function is_logged_in() {
    return !empty($_SESSION['user_id']);
}

function current_user() {
    if (!is_logged_in()) return null;
    return find_user_by_id($_SESSION['user_id']);
}

function require_role($role) {
    $user = current_user();
    if (!$user || $user['role'] !== $role) {
        header("Location: " . BASE_URL . "/login.php");
        exit;
    }
}
