<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/functions.php';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Please enter a valid email address.";
    }
    if ($password === '') {
        $errors[] = "Please enter your password.";
    }

    if (!$errors) {
        $users = read_json('users.json');
        $user  = null;

        foreach ($users as $u) {
            if (strtolower($u['email']) === strtolower($email)) {
                $user = $u;
                break;
            }
        }

        if (!$user || empty($user['password_hash']) || !password_verify($password, $user['password_hash'])) {
            $errors[] = "Email or password is incorrect.";
        } else {
            // Check status
            if (!empty($user['status']) && $user['status'] === 'pending') {
                $errors[] = "Your account is pending approval by Londons Energy Radio.";
            } else {
                // Login
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['role']    = $user['role'] ?? 'artist';

                if ($_SESSION['role'] === 'admin') {
                    header("Location: dashboard/admin-dashboard.php");
                } else {
                    header("Location: dashboard/artist-dashboard.php");
                }
                exit;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login • Londons Energy Artist Portal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link rel="stylesheet" href="assets/css/main.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <script src="assets/js/main.js" defer></script>
</head>
<body class="dark-bg">
  <div class="page-bg"></div>

  <!-- SMALL TOP BAR (same style as rest of portal) -->
  <header class="site-header site-header--sticky">
    <div class="site-header-inner">
      <a href="index.php" class="site-brand">
        <img
          src="https://londonsenergyradio.co.uk/wp-content/uploads/2022/12/Energy-radio-p3h439ea3kdydq5pmbj4z4m1ek89863lffdvjk6qmc.png"
          alt="Londons Energy Radio"
          class="site-logo"
        >
        <div class="site-brand-text">
          <span class="site-brand-top">Londons Energy Radio</span>
          <span class="site-brand-sub">Artist Portal</span>
        </div>
      </a>

      <button class="nav-toggle" type="button" aria-controls="primary-nav" aria-expanded="false">

        <span class="sr-only">Menu</span>

        <i class="fa-solid fa-bars"></i>

      </button>


      <nav class="site-nav" id="primary-nav" aria-label="Primary">
        <a href="index.php" class="nav-link">Artists</a>
        <a href="packages.php" class="nav-link">Packages</a>
        <a href="submit-artist.php" class="nav-link">Submit Music</a>
        <a href="login.php" class="nav-link nav-link--active">
          <i class="fa-solid fa-right-to-bracket"></i>
          Login
        </a>
      </nav>
    </div>
  </header>

  <div class="nav-overlay" data-nav-close></div>

  <main class="auth-wrapper">
    <div class="auth-card">
      <div class="auth-logo">
        <img
          src="https://londonsenergyradio.co.uk/wp-content/uploads/2022/12/Energy-radio-p3h439ea3kdydq5pmbj4z4m1ek89863lffdvjk6qmc.png"
          alt="Londons Energy Radio"
        >
      </div>
      <h1 class="auth-title">Artist Portal Login</h1>
      <p class="auth-subtitle">Access your dashboard to manage tracks, promo packages and billing.</p>

      <?php if ($errors): ?>
        <div class="auth-errors">
          <ul>
            <?php foreach ($errors as $e): ?>
              <li><?= htmlspecialchars($e) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <form method="post" class="auth-form">
        <div class="auth-field">
          <label for="email">Email</label>
          <div class="auth-input-wrap">
            <i class="fa-solid fa-at"></i>
            <input
              type="email"
              id="email"
              name="email"
              required
              value="<?= htmlspecialchars($_POST['email'] ?? '') ?>"
              placeholder="you@example.com"
            >
          </div>
        </div>

        <div class="auth-field">
          <label for="password">Password</label>
          <div class="auth-input-wrap">
            <i class="fa-solid fa-lock"></i>
            <input
              type="password"
              id="password"
              name="password"
              required
              placeholder="••••••••"
            >
          </div>
        </div>

        <div class="auth-actions">
          <button type="submit" class="btn-primary auth-btn-main">
            <i class="fa-solid fa-right-to-bracket"></i>
            Login
          </button>
        </div>
      </form>

      <div class="auth-footer-links">
        <a href="index.php" class="btn-secondary auth-btn-secondary">
          ← Back to Portal
        </a>
        <p>New here? <a href="register.php">Create an account</a> or go straight to <a href="submit-artist.php">Submit Music</a>.</p>
      </div>
    </div>
  </main>

  <footer class="site-footer">
    KEEPING IT ENERGY • LONDONS ENERGY RADIO
  </footer>
</body>
</html>
